/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analyzer.sensor;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.Project;
import org.sonarsource.sonarlint.core.analyzer.sensor.BatchExtensionDictionnary;

@BatchSide
public class SensorsExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(SensorsExecutor.class);
    private Project module;
    private BatchExtensionDictionnary selector;

    public SensorsExecutor(BatchExtensionDictionnary selector, Project project) {
        this.selector = selector;
        this.module = project;
    }

    public void execute(SensorContext context) {
        Collection<Sensor> sensors = this.selector.select(Sensor.class, this.module, true, null);
        for (Sensor sensor : sensors) {
            this.executeSensor(context, sensor);
        }
    }

    private void executeSensor(SensorContext context, Sensor sensor) {
        LOG.debug("Execute Sensor: " + sensor.toString());
        sensor.analyse(this.module, context);
    }
}

